include <BOSL2/std.scad>

// Inspired by https://www.youtube.com/watch?v=3V80-Fm_5Gs
// See http://iotic.com/flutomat/


// Params start
// Body
inside_diameter = 16; //mm
wall_thickness = 1.25; //mm
mouthpiece_length = 22; //mm
mouthpiece_angle = 45; //deg

// Tunings
edge_distance = 270;//mm distance from center of edge distance to end of flute
extra_tuning_length = 10; //mm
extra_tuning_diameter = 2.5; //mm

holes = [[7,146.5],[7.5,128],[8,107],[6.5,83.5],[9,65],[8,39]];//[diameter,distance_from_end_of_flute]

// Duct
edge_length = 5;//mm
duct_width=7;//mm
edge_angle=60;//deg
edge_fine_tune_x = 0.7; //mm until edge is continuous
edge_fine_tune_z = 1.3; //mm until the curve is gone from the cylinder
mouthpiece_external_cut_width=4;//mm
mouthpiece_external_cut_height=10;//mm

// Print
tolerance = 0.05; //mm
clip_plane_size = [100,100,100];//mm
resolution = 100;

//Calc
body_length=mouthpiece_length+edge_distance+edge_length/2+extra_tuning_length;

// Params end

module clip_angle(){
    translate([-inside_diameter/2-wall_thickness*2,-inside_diameter/2-wall_thickness*2,mouthpiece_length]) rotate([0,mouthpiece_angle,0])cube(clip_plane_size);}

difference(){
        cylinder(d=inside_diameter-tolerance*2,h=mouthpiece_length,$fn=resolution);
    clip_angle();
}